/**
 * This file is part of the QCAD/CAM software.
 * Do NOT edit this file. Your changes will be lost when the software 
 * is updated or reinstalled. 
 * For details, please refer to the file README.txt in this directory.
 */
include("GCodeBase.js");

function GCodeLaserOffset(documentInterface, camDocumentInterface) {
    GCodeBase.call(this, documentInterface, camDocumentInterface);

    this.outputOffsetPath = true;

    // disable all Z moves:
    this.rapidMoveZ = [];
    this.firstLinearMoveZ = [];
    this.linearMoveZ = [];
    this.firstPointMoveZ = [];
    this.pointMoveZ = [];

    // stop cutting at tab:
    this.stopAtTab = true;

    // disable tool changes:
    this.toolHeader = [];
}

GCodeLaserOffset.prototype = new GCodeBase();
GCodeLaserOffset.displayName = "";

// don't change this.lastMoveGCode for Z moves:
GCodeLaserOffset.prototype.writeFirstLinearMoveZ = function() {};
GCodeLaserOffset.prototype.writeLinearMoveZ = function() {};
GCodeLaserOffset.prototype.writeFirstPointMoveZ = function() {};
GCodeLaserOffset.prototype.writePointMoveZ = function() {};

GCodeLaserOffset.prototype.getToolTypeTitle = function(toolType) {
    if (isString(toolType)) {
        toolType = parseInt(toolType);
    }

    switch (toolType) {
    case Cam.ToolType.Mill:
        return qsTr("Laser");
    default:
        return undefined;
    }
};

/**
 * Initializes the pass headers / footers to switch LASER on / off
 * based on the users postprocessor preferences.
 */
GCodeLaserOffset.prototype.writeFile = function(fileName) {
    // get configured values:
    var laserOnCode = this.getGlobalOption("CamLaserOnCode", "M03");
    var laserOffCode = this.getGlobalOption("CamLaserOffCode", "M05");

    // initialize G-Code blocks for pass header (LASER on):
    if (laserOnCode.length===0) {
        this.zPassHeader = [];
    }
    else {
        this.zPassHeader = [ "[N] " + laserOnCode];
    }
    this.zPassFirstHeader = this.zPassHeader;

    // initialize G-Code blocks for pass footer (LASER off):
    if (laserOffCode.length===0) {
        this.zPassFooter = [];
    }
    else {
        this.zPassFooter = [ "[N] " + laserOffCode];
    }
    this.zPassLastFooter = this.zPassFooter;

    // call base implemenation of writeFile:
    return GCodeBase.prototype.writeFile.call(this, fileName);
};

/**
 * Adds controls to the postprocessor configuration dialog to
 * configure LASER on / off G-Codes.
 */
GCodeLaserOffset.prototype.initConfigDialog = function(dialog) {
    // add options for laser on / off:
    var group = dialog.findChild("GroupCustom");
    group.title = qsTr("LASER Controller");

    // get QVBoxLayout:
    var vBoxLayout = group.layout();

    // add label and combo box to choose LASER on / off codes:
    var hBoxLayout = new QHBoxLayout(null);
    vBoxLayout.addLayout(hBoxLayout, 0);

    var lLaserOn = new QLabel(qsTr("LASER on:"));
    hBoxLayout.addWidget(lLaserOn, 0,0);

    var cbLaserOn = new QComboBox();
    cbLaserOn.editable = true;
    cbLaserOn.objectName = "CamLaserOnCode";
    cbLaserOn.addItem("M03");
    cbLaserOn.addItem("M07");
    cbLaserOn.addItem("M10");
    cbLaserOn.addItem("S255 M03");
    cbLaserOn.addItem("S255");
    hBoxLayout.addWidget(cbLaserOn, 0,0);

    hBoxLayout = new QHBoxLayout(null);
    vBoxLayout.addLayout(hBoxLayout, 0);

    var lLaserOff = new QLabel(qsTr("LASER off:"));
    hBoxLayout.addWidget(lLaserOff, 0,0);

    var cbLaserOff = new QComboBox();
    cbLaserOff.editable = true;
    cbLaserOff.objectName = "CamLaserOffCode";
    cbLaserOff.addItem("M05");
    cbLaserOff.addItem("M08");
    cbLaserOff.addItem("M11");
    cbLaserOff.addItem("S0 M05");
    cbLaserOff.addItem("S0");
    hBoxLayout.addWidget(cbLaserOff, 0,0);
};
