/**
 * This file is part of the QCAD/CAM software.
 * Do NOT edit this file. Your changes will be lost when the software 
 * is updated or reinstalled. 
 * For details, please refer to the file README.txt in this directory.
 */
include("GCodeBase.js");

function ExpandedPoly(cadDocumentInterface, camDocumentInterface) {
    GCodeBase.call(this, cadDocumentInterface, camDocumentInterface);

    this.decimals = 0;
    this.unit = RS.Millimeter;

    this.fileExtensions = [ "txt" ];

    this.header = [
        "(Start code)",
        "G28",
        "(Move to start)",
        "(MSG, Moving to Start Point)",
        "G00 [Y!] A[Y#!]",
        "G00 [X!] Z[X#!]",
        "M0",
        "(Begin Cutting)",
        "(MSG, Heating Wire)",
        "M1001",
        "G4 P4"
    ];
    this.footer = [
        "(End Code)",
        "M1000",
        "G4 P4",
        "G28 Y0 A0",
        "G28 X0 Z0",
        "M30"
    ];
    this.toolpathHeader = [ ];
    this.toolpathFooter = [ ];
    this.toolHeader = [ ];

    this.rapidMove =                 "G00 X[X#!] Y[Y#!] Z[X#!] A[Y#!]";
    this.rapidMoveZ =                [ ];

    this.firstLinearMove =           "G01 X[X#!] Y[Y#!] Z[X#!] A[Y#!] [F]";
    this.linearMove =                this.firstLinearMove;

    this.firstLinearMoveZ =          [ ];
    this.linearMoveZ =               [ ];

    this.firstArcCWMove =            "G2 X[X#!] Y[Y#!] Z[X#!] A[Y#!] [I] [J] [F]";
    this.arcCWMove =                 this.firstArcCWMove;

    this.firstArcCCWMove =           "G3 X[X#!] Y[Y#!] Z[X#!] A[Y#!] [I] [J] [F]";
    this.arcCCWMove =                this.firstArcCCWMove;

    this.linearMoveCompensationLeft = this.linearMove;
    this.linearMoveCompensationRight = this.linearMove;
    this.linearMoveCompensationOff = this.linearMove;
}

ExpandedPoly.prototype = new GCodeBase();
ExpandedPoly.displayName = "Expanded Poly";
