/**
 * This file is part of the QCAD/CAM software.
 * Do NOT edit this file. Your changes will be lost when the software 
 * is updated or reinstalled. 
 * For details, please refer to the file README.txt in this directory.
 */
include("GCodeBase.js");

/**
 * Base configuration for LC30MM controllers. 
 * Defines footer and compensation off move.
 */
function LC30MM(documentInterface, camDocumentInterface) {
    GCodeBase.call(this, documentInterface, camDocumentInterface);

    // first line number:
    this.lineNumber = 1;
    // line number increment:
    this.lineNumberIncrement = 1;
    this.unit = RS.Millimeter;

    this.header = [
        "%",
        "M66",
        "G90",
        "G92X0Y0",
        "G51X0Y0P1.00",
        "M750"
    ];

    this.footer = [
        "G28Z0",
        "M30",
        "%"
    ];

    this.toolHeader = [];

    this.toolpathHeader = [
        "",
        "[N]"
    ];
    this.toolpathFooter = [];

    this.rapidMove =                 "G0[X][Y]";
    this.rapidMoveZ =                [];

    this.firstLinearMove =           "G01[X][Y]";
    this.firstLinearMoveZ =          [];
    this.linearMove =                "G01[X][Y]";
    this.linearMoveZ =               [];

    this.firstArcCWMove =            "G02[X][Y][I][J]";
    this.arcCWMove =                 this.firstArcCWMove;

    this.firstArcCCWMove =           "G03[X][Y][I][J]";
    this.arcCCWMove =                this.firstArcCCWMove;

    this.linearMoveCompensationLeft = [
        // getting ready to cut (Z move?):
        "M98P9010",
        // radius compensation with given diameter:
        "G41G01[X][Y]D[TD]"
    ];
    this.linearMoveCompensationRight = [
        "M98P9010",
        "G42G01[X][Y]D[TD]"
    ];
    this.linearMoveCompensationOff = [
        // tool up / stop cutting (?)
        "M121",
        "M199",
        // switch comensation off:
        "G00G40[X][Y]"
    ];
}

LC30MM.prototype = new GCodeBase();
LC30MM.displayName = "LC30 [mm]";
