/**
 * This file is part of the QCAD/CAM software.
 * Do NOT edit this file. Your changes will be lost when the software 
 * is updated or reinstalled. 
 * For details, please refer to the file README.txt in this directory.
 */
include("Grbl.js");

/**
 * Configuration for Grbl controllers.
 * Output in Millimeters.
 */
function GrblMM(documentInterface, camDocumentInterface) {
    Grbl.call(this, documentInterface, camDocumentInterface);

    this.decimals = 4;
    this.unit = RS.Millimeter;
    this.outputOffsetPath = true;

    // see https://www.shapeoko.com/wiki/index.php/G-Code
    // G21: Millimeter unit
    // G17: XY Plane select
    // G90: Absolute distance mode
    // G40: Cancel cutter radius compensation
    //      (the only supported mode for Grbl)
    // G49: Cancel tool length offset
    // G80: Cancel motion mode
    // G71: Millimeter unit (unsupported?)
    // G91.1: Incremental distance mode for I/J
    this.header = [
        "[N] G21 G17 G90 G40 G49 G80",
        "[N] G91.1"
    ];
}

GrblMM.prototype = new Grbl();
GrblMM.displayName = "GRBL (Offset) [mm]";
