/**
 * This file is part of the QCAD/CAM software.
 * Do NOT edit this file. Your changes will be lost when the software 
 * is updated or reinstalled. 
 * For details, please refer to the file README.txt in this directory.
 */
include("GCodeBase.js");

function LinuxCNC(cadDocumentInterface, camDocumentInterface) {
    GCodeBase.call(this, cadDocumentInterface, camDocumentInterface);

    this.linearMoveCompensationOff = "[N] G40 G1 [X] [Y]";
}

LinuxCNC.prototype = new GCodeBase();

LinuxCNC.displayName = "";

/**
 * Write tool list in header.
 */
LinuxCNC.prototype.writeHeader = function() {
    this.writeBlock("header");

    // backup member variables:
    var tool = this.tool;
    var toolDiameter = this.toolDiameter;
    var toolRadius = this.toolRadius;

    // write list of tools with tool radius
    var toolNames = Cam.getToolNames(this.cadDocument);
    toolNames.sort(Array.alphaNumericalSorter);
    //toolNames = RS.sortAlphanumerical(toolNames);
    for (var i=0; i<toolNames.length; i++) {
        var toolName = toolNames[i];

        // temporarily overwrite member variables:
        this.tool = toolName;
        this.toolDiameter = Cam.getToolDiameter(this.cadDocument, toolName, 0.0);
        this.toolRadius = this.toolDiameter/2;

        this.writeBlockFromString("[N] G10 L1 P[T#] R[TR#]");
    }

    // restore member variables:
    this.tool = tool;
    this.toolDiameter = toolDiameter;
    this.toolRadius = toolRadius;
};
