/**
 * This file is part of the QCAD/CAM software.
 * Do NOT edit this file. Your changes will be lost when the software 
 * is updated or reinstalled. 
 * For details, please refer to the file README.txt in this directory.
 */
include("scripts/Cam/CamExportV2/CamExporterV2.js");

/**
 * Outputs HTML, mainly used for debugging the structure of text blocks 
 * written to the output file.
 */
function Html(cadDocumentInterface, camDocumentInterface) {
    // call constructor of base class 'CamExporterV2':
    CamExporterV2.call(this, cadDocumentInterface, camDocumentInterface);

    if (isNull(cadDocumentInterface)) {
        // constructor used as prototype:
        return;
    }

    var decimals = 1;
    this.normalizeWhiteSpace = false;
    this.trimSpacesStart = false;
    this.trimSpacesEnd = false;
    this.fileExtensions = [ "html" ];

    this.registerVariable("tool",                "T",                    true,  "T", 0);
    this.registerVariable("feedRate",            "F",                    false, "F", 0);
    this.registerVariable("xPosition",           "X",                    true,  "X", decimals);
    this.registerVariable("yPosition",           "Y",                    true,  "Y", decimals);
    this.registerVariable("zPosition",           "Z",                    true,  "Z", decimals);
    this.registerVariable("writeEntityIndex",    "INDEX",                true,  "", 0);
    this.registerVariable("writeEntityIndexMax", "MAXINDEX",             true,  "", 0);

    var ind = [];
    for (var i=0; i<20; i++) {
        ind[i] = new Array(i + 1).join("&nbsp;&nbsp;");
    }

    var lf = "<br/>";
    var preGCode = "<font style='font-size:8pt;color:blue;'>";
    var postGCode = "</font>";

    // output blocks:
    this.header = [
        "<html><body style='font-family:sans-serif;font-size:10pt;'>" + ind[0] + "header" + lf
    ];
    this.footer = [
        ind[0] + "footer" + lf + "</body></html>"
    ];

    var n=1;
    this.toolHeader = [
        ind[n] + "toolHeader" + lf,
        ind[n] + preGCode + "[T]" + postGCode + lf
    ];
    this.toolFooter = [
        ind[n] + "toolFooter" + lf
    ];

    n++;
    this.toolpathHeader = [
        ind[n] + "toolpathHeader" + lf
    ];
    this.toolpathFooter = [
        ind[n] + "toolpathFooter" + lf
    ];

    n++;
    this.contourHeader = [
        ind[n] + "contourHeader" + lf
    ];
    this.contourFooter = [
        ind[n] + "contourFooter" + lf
    ];

    n++;
    this.singleZPassHeader = [
        ind[n] + "singleZPassHeader" + lf
    ];
    this.singleZPassFooter = [
        ind[n] + "singleZPassFooter" + lf
    ];

    this.multiZPassHeader = [
        ind[n] + "multiZPassHeader" + lf
    ];
    this.multiZPassFooter = [
        ind[n] + "multiZPassFooter" + lf
    ];
    n++;
    this.zPassFirstHeader = [
        ind[n] + "zPassFirstHeader" + lf
    ];
    this.zPassHeader = [
        ind[n] + "zPassHeader" + lf
    ];
    this.zPassFooter = [
        ind[n] + "zPassFooter" + lf
    ];
    this.zPassLastFooter = [
        ind[n] + "zPassLastFooter" + lf
    ];

    n++;
    this.rapidMove = [
         ind[n] + "rapidMove [INDEX]/[MAXINDEX]" + lf,
         ind[n] + preGCode + "G0 [X] [Y]" + postGCode + lf
    ];
    this.rapidMoveZ = [
         ind[n] + "rapidMoveZ [INDEX]/[MAXINDEX]" + lf,
         ind[n] + preGCode + "G0 [Z]" + postGCode + lf
    ];

    this.firstLinearMove = [
         ind[n] + "firstLinearMove [INDEX]/[MAXINDEX]" + lf,
         ind[n] + preGCode + "G1 [X] [Y] [F]" + postGCode + lf
    ];
    this.firstLinearMoveZ = [
         ind[n] + "firstLinearMoveZ [INDEX]/[MAXINDEX]" + lf,
         ind[n] + preGCode + "G1 [Z] [F]" + postGCode + lf
    ];

    this.linearMove = [
         ind[n] + "linearMove [INDEX]/[MAXINDEX]" + lf,
         ind[n] + preGCode + "[X] [Y] [F]" + postGCode + lf
    ];
    this.linearMoveZ = [
         ind[n] + "linearMoveZ [INDEX]/[MAXINDEX]" + lf,
         ind[n] + preGCode + "[Z] [F]" + postGCode + lf
    ];

    this.firstArcCWMove = [
         ind[n] + "firstArcCWMove [INDEX]/[MAXINDEX]" + lf,
         ind[n] + preGCode + "G2 [X] [Y] [I] [J] [F]" + postGCode + lf
    ];
    this.arcCWMove = [
         ind[n] + "arcCWMove [INDEX]/[MAXINDEX]" + lf,
         ind[n] + preGCode + "[X] [Y] [I] [J] [F]" + postGCode + lf
    ];

    this.firstArcCCWMove = [
         ind[n] + "firstArcCCWMove [INDEX]/[MAXINDEX]" + lf,
         ind[n] + preGCode + "G3 [X] [Y] [I] [J] [F]" + postGCode + lf
    ];
    this.arcCCWMove = [
         ind[n] + "arcCCWMove [INDEX]/[MAXINDEX]" + lf,
         ind[n] + preGCode + "[X] [Y] [I] [J] [F]" + postGCode + lf
    ];

    this.linearMoveCompensationLeft = [
         ind[n] + "linearMoveCompensationLeft [INDEX]/[MAXINDEX]" + lf,
         ind[n] + preGCode + "G41 [X] [Y] [F]" + postGCode + lf
    ];
    this.linearMoveCompensationRight = [
         ind[n] + "linearMoveCompensationRight [INDEX]/[MAXINDEX]" + lf,
         ind[n] + preGCode + "G42 [X] [Y] [F]" + postGCode + lf
    ];
    this.linearMoveCompensationOff = [
         ind[n] + "linearMoveCompensationOff [INDEX]/[MAXINDEX]" + lf,
         ind[n] + preGCode + "G40 [X] [Y] [F]" + postGCode + lf
    ];
}

Html.prototype = new CamExporterV2();
Html.displayName = "HTML (Structure)";

